/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.filesystem.ftp.internal;

import com.aptana.core.util.KeepAliveObjectPool;
import com.aptana.filesystem.ftp.internal.IPoolConnectionManager;
import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPTransferType;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FTPClientPool
extends KeepAliveObjectPool<FTPClientInterface> {
    private IPoolConnectionManager manager;

    public FTPClientPool(IPoolConnectionManager manager) {
        super(Platform.getPreferencesService().getInt("com.aptana.filesystem.ftp", "KeepAliveTime", 7, null) * 60 * 1000);
        this.manager = manager;
        this.start();
    }

    public FTPClientInterface create() {
        return this.manager.newClient();
    }

    public void expire(FTPClientInterface ftpClient) {
        if (ftpClient == null) {
            return;
        }
        try {
            ftpClient.quit();
        }
        catch (Exception e) {
            try {
                ftpClient.quitImmediately();
            }
            catch (Exception ignore) {
                ignore.getCause();
            }
        }
    }

    public boolean validate(FTPClientInterface o) {
        if (!o.connected()) {
            return false;
        }
        if (o instanceof FTPClient) {
            try {
                ((FTPClient)o).noOperation();
                ((FTPClient)o).setType(FTPTransferType.BINARY);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }
}

